// $Id: CKeyboardEvent.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CKeyboardEvent.hpp"
using Exponent::GUI::Events::CKeyboardEvent;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CKeyboardEvent, CCountedObject);

//	===========================================================================
CKeyboardEvent::CKeyboardEvent()
			  : m_key(' ')
			  , m_shiftIsDown(false)
			  , m_altIsDown(false)
			  , m_ctrlIsDown(false)
{
	EXPONENT_CLASS_CONSTRUCTION(CKeyboardEvent);
}

//	===========================================================================
CKeyboardEvent::~CKeyboardEvent()
{
	EXPONENT_CLASS_DESTRUCTION(CKeyboardEvent);
}

//	===========================================================================
void CKeyboardEvent::setKey(const char key) 
{ 
	m_key = key; 
}

//	===========================================================================
void CKeyboardEvent::setModifiers(const bool ctrl, const bool shift, const bool alt)
{
	m_ctrlIsDown  = ctrl;
	m_shiftIsDown = shift;
	m_altIsDown   = alt;
}

//	===========================================================================
char CKeyboardEvent::getKey() const 
{ 
	return m_key; 
}

//	===========================================================================
bool CKeyboardEvent::isCtrlDown() const 
{ 
	return m_ctrlIsDown; 
}

//	===========================================================================
bool CKeyboardEvent::isShiftDown() const 
{ 
	return m_shiftIsDown; 
}

//	===========================================================================
bool CKeyboardEvent::isAltDown() const 
{ 
	return m_altIsDown;
}